#include "Util.h"

string ReadFLine( FILE * f )
{
	string sRet;
	char b;
	while( !ferror( f ) && !feof( f ) )
	{
		fread( &b, 1, 1, f );
		switch (b)
		{
		case '\r':	//Assume no bare line feeds
			fread( &b, 1, 1, f );
		case '\n':
			return sRet;
		default:
			sRet += b;
		}
	}
	if ( sRet.length() > 0 )
		return sRet.substr(0,sRet.length()-1);
	else
		return sRet;
}

#if defined(WIN32)
#include <windows.h>
#endif

void XSleep( float msec )
{
#if defined( WIN32 )
    #if defined(__GNUC__)
	    Sleep( DWORD(msec) );
    #else
	    Sleep( unsigned long(msec) );
    #endif
#else
	usleep(((unsigned long)msec)*1000);
#endif
}

string ConvertToCFormat( const string & ncf )
{
	string ret;
	const char* nccf = ncf.c_str();

	for ( int i = 0; (unsigned)i < ncf.length(); i++ )
	{
		switch ( nccf[i] )
		{
		case '\t':	ret += "\\t";	break;
		case '\n':	ret += "\\n";	break;
		case '\r':	ret += "\\r";	break;
		case '\f':	ret += "\\f";	break;
		case '\b':	ret += "\\b";	break;
		case '\\':	ret += "\\\\";	break;
		case '\'':	ret += "\\\'";	break;
		case '\"':	ret += "\\\"";	break;
		default:
			if( nccf[i] < 32 )
			{
				ret += "\\"; 
				ret += ((unsigned char)nccf[i]/64)%8 + '0';
				ret += ((unsigned char)nccf[i]/8)%8 + '0';
				ret += (unsigned char)nccf[i]%8 + '0';
			} else
				ret += nccf[i];
		}
	}
	return ret;
}

string ConvertToUnformatted( const string & cf )
{
	string ret;
	const char* ccf = cf.c_str();

	for ( int i = 0; (unsigned)i < cf.length(); i++ )
	{
		switch ( ccf[i] )
		{
		case '\\':
			i++;
			if ( (unsigned)i >= cf.length() )
				return ret;
			switch ( ccf[i] )
			{
			case 't':	ret += '\t';	break;
			case 'n':	ret += '\n';	break;
			case 'r':	ret += '\r';	break;
			case 'f':	ret += '\f';	break;
			case 'b':	ret += '\b';	break;
			case '\\':	ret += '\\';	break;
			case '\'':	ret += '\'';	break;
			case '\"':	ret += '\"';	break;
			default:
				if( ccf[i] >= '0' && ccf[i] <= '7' )
				{
					char c = ccf[i] - '0';
					if( ccf[i+1] >= '0' && ccf[i+1] <= '8' )
					{
						i++;
						c = c * 8 + ccf[i] - '0';
					}
					if( ccf[i+1] >= '0' && ccf[i+1] <= '8' )
					{
						i++;
						c = c * 8 + ccf[i] - '0';
					}
					ret += c;
				}
			}
			break;
		default:
			ret += ccf[i];
		}
	}
	return ret;
}


/* 
 * (c) 2006 Charles Lohr
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
